clear();
clc();
close all;                              											%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
aWERTETABELLE(1,:)  =["Xi", 0, 1,       2.5,    3,      4.5,    5,      6];
aWERTETABELLE(2,:)  =["Yi", 0, 5.4375,  7.3516, 7.5625, 8.4453, 9.1875, 12];
sKommastellenDouble = '%.8f';          												%Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_WERTE = size(aWERTETABELLE,2)-1;                                            %Gibt die Anzahl der Spalten zurück (Parameter 2) abzüglich 1 (Der Bezeichner der Wertereihe)

%INITIALISIERUNG-------------------------------------------------------------------
aDIVDIFF(1,:)=["Xi","Fi"];
Speicher = "F[Xi";
for(i=3:1:(iANZAHL_WERTE+2-1))                                                      %Erzeugung der dynamischen Kopfzeile
    Speicher = strcat(Speicher,",Xi+",num2str(i-2));
    aDIVDIFF(1,i)=[strcat(Speicher,"]")];
end
aDIVDIFF(2:(2*iANZAHL_WERTE),1:((iANZAHL_WERTE)+1))=[""];                           %Auffüllung des Arrays mit leeren Strings

%BERECHNUNG_DER_DIVIDIERENDEN_DIFFERENZEN------------------------------------------
for(i=1:1:iANZAHL_WERTE)                                                            %Übertragung der Wertetabelle in die differierenden-Differenzen-Tabelle
    aDIVDIFF(2*i,1)=aWERTETABELLE(1,i+1);
    aDIVDIFF(2*i,2)=aWERTETABELLE(2,i+1);
end
for(i=1:1:iANZAHL_WERTE-1)                                                          %Definiert das Durchlaufen der Berechnungsspalten
    for(j=2+i:2:(2*iANZAHL_WERTE)-i)                                                %Definiert das Durchlaufen der Berechnungszeilen
        aDIVDIFF(j,2+i)=num2str((str2double(aDIVDIFF(j+1,1+i))-str2double(aDIVDIFF(j-1,1+i)))/(str2double(aDIVDIFF(j+i,1))-str2double(aDIVDIFF(j-i,1))),sKommastellenDouble);
    end
end
disp(aDIVDIFF);

%BERECHNUNG_DER_NEWTON'SCHEN_INTERPOLATIONSFORMEL----------------------------------
aINTERPOLATIONSFORMEL(1,1)=["P(x)="];
Speicher="";
for(i=1:1:iANZAHL_WERTE) 
    aINTERPOLATIONSFORMEL(1,1+i)=strcat("A",num2str(i-1),Speicher);
    Speicher=strcat(Speicher,"*(X-X",num2str(i-1),")");
end
%Initialisierung der Hilfsmatrix A und X
for(i=1:1:iANZAHL_WERTE) 
    A_WERTE(i)=str2double(aDIVDIFF(1+i,1+i));
    X_WERTE(i)=str2double(aDIVDIFF(2*i,1));
end
%Befüllen der Diagonalen der X-Maske
aX_MASKE=eye(iANZAHL_WERTE,iANZAHL_WERTE);                                          %Hauptdiagonale mit 1 befüllt
for(i=1:1:iANZAHL_WERTE)
    aX_MASKE_TEXT(i,i)="1";
end
for(i=1:1:iANZAHL_WERTE-1)                                                          %Anzahl der Diagonalen unter Hauptdiagonalen um 1 kleiner als Anzahl als beide Matrixdimensionen
    for(j=1:1:iANZAHL_WERTE-i)                                                      %Zählt die Anzahl der Werte einer Hauptdiagonalen (die erste Diagnonale hat 3 bei 4 Werten; die zweite hat 2 bei 4 Werten)
        A=[0:j-1+i-1];                                                              %j-1 setzt die Variable auf den Startwert 0 statt 1; +i-1 ist + Diagonale -1
        B=perms(A);                                                                 %erzeugt Alle möglichen Kombinationen der aufsteigenden X-Indexe in A
        C=B(1:end,1:i);                                                             %schneidet von den Kombinationen Spalten ab
        for(k=1:1:size(C,1))
           C(k,:)=sort(C(k,:),'ascend');                                            %sortiert jede einzelne Zeile mit den Wrten aufsteigend
        end
        C=unique(C,'rows');                                                         %löscht Duplikate von Zeilen
        Zwischenspeicher_Summanden=0;
        Textspeicher_Summanden="";
        for(k=1:1:size(C,1))
            Zwischenspeicher_Faktoren=1;
            Textspeicher_Faktoren="";
            for(l=1:1:size(C,2))
                Zwischenspeicher_Faktoren=Zwischenspeicher_Faktoren*X_WERTE(C(k,l)+1);
                Textspeicher_Faktoren=strcat(Textspeicher_Faktoren,"*X",int2str(C(k,l)));
            end
            Zwischenspeicher_Summanden=Zwischenspeicher_Summanden+Zwischenspeicher_Faktoren;
            Textspeicher_Summanden=strcat(Textspeicher_Summanden,"+(",Textspeicher_Faktoren,")");
        end
        aX_MASKE(j+i,j)=Zwischenspeicher_Summanden;
        aX_MASKE_TEXT(j+i,j)=strrep(Textspeicher_Summanden,"+(*","+(");
    end
end
%Befüllen der Diagonalen der A-Maske
for(i=1:1:iANZAHL_WERTE)
    for(j=0:1:iANZAHL_WERTE-i)
        if(mod(i,2)~=0)
            aA_MASKE(j+i,j+1)=A_WERTE(i+j);
            aA_MASKE_TEXT(j+i,j+1)=strcat("A",num2str(i+j));
        else
            aA_MASKE(j+i,j+1)=-A_WERTE(i+j);
            aA_MASKE_TEXT(j+i,j+1)=strcat("-A",num2str(i+j));
        end
    end
end
%Multiplizieren der X-Maske mit A-Maske
for(i=1:1:iANZAHL_WERTE)
    for(j=1:1:i)
        aAX_WERTE(i,j)=aA_MASKE(i,j)*aX_MASKE(i,j);
        aAX_WERTE_TEXT(i,j)=strcat(aA_MASKE_TEXT(i,j),"*{",aX_MASKE_TEXT(i,j),"}");
    end
end
%Summieren zum Endergebnis
for(i=1:1:iANZAHL_WERTE)
    INTERPOLATIONSFORMEL(i)=0;
    for(j=1:1:iANZAHL_WERTE)
        INTERPOLATIONSFORMEL(i)=INTERPOLATIONSFORMEL(i)+aAX_WERTE(j,i)
    end
end

%DOKUMENTIERUNG_DES_RECHENWEGS-----------------------------------------------------
LetzteZeile=size(aINTERPOLATIONSFORMEL,1)+1;
aINTERPOLATIONSFORMEL(LetzteZeile,1)=["P(x)="];
Speicher="";
for(i=1:1:iANZAHL_WERTE) 
    aINTERPOLATIONSFORMEL(LetzteZeile+i-1,2:iANZAHL_WERTE+1)=aAX_WERTE_TEXT(i,:);
    Speicher=strcat(Speicher,"*(X-",aDIVDIFF(2*i,1),")");
end
LetzteZeile=size(aINTERPOLATIONSFORMEL,1)+1;
aINTERPOLATIONSFORMEL(LetzteZeile,1)=["P(x)="];
Speicher="";
for(i=1:1:iANZAHL_WERTE) 
    aINTERPOLATIONSFORMEL(LetzteZeile,1+i)=strcat(aDIVDIFF(1+i,1+i),Speicher);
    Speicher=strcat(Speicher,"*(X-",aDIVDIFF(2*i,1),")");
end
LetzteZeile=size(aINTERPOLATIONSFORMEL,1)+1;
aINTERPOLATIONSFORMEL(LetzteZeile,1)=["P(x)="];
Speicher="";
for(i=1:1:iANZAHL_WERTE) 
    aINTERPOLATIONSFORMEL(LetzteZeile+i-1,2:iANZAHL_WERTE+1)=aAX_WERTE(i,:);
    Speicher=strcat(Speicher,"*(X-",aDIVDIFF(2*i,1),")");
end
LetzteZeile=size(aINTERPOLATIONSFORMEL,1)+1;
aINTERPOLATIONSFORMEL(LetzteZeile,1)=["P(x)="];
for(i=1:1:iANZAHL_WERTE) 
    aINTERPOLATIONSFORMEL(LetzteZeile,1+i)=strcat(num2str(INTERPOLATIONSFORMEL(i),sKommastellenDouble),"*X^",num2str(i-1));
end
disp(aINTERPOLATIONSFORMEL);

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X=min(str2double(aWERTETABELLE(1,2:end))):(max(str2double(aWERTETABELLE(1,2:end)))-min(str2double(aWERTETABELLE(1,2:end))))/Inkrement:max(str2double(aWERTETABELLE(1,2:end)));
for(i=1:1:Inkrement+1)
    Y(i)=0;
    for(j=1:1:iANZAHL_WERTE) 
        Y(i)=Y(i)+INTERPOLATIONSFORMEL(j)*(X(i)^(j-1));
    end 
end
scatter(aWERTETABELLE(1,2:end),aWERTETABELLE(2,2:end),100,'o');
hold on;                                                                        		%Warten bis zur Plotausgabe
Offset=0.1;
text(str2double(aWERTETABELLE(1,2:end))+Offset,str2double(aWERTETABELLE(2,2:end))+Offset,cellstr(strcat(aWERTETABELLE(1,2:end)," | ",aWERTETABELLE(2,2:end))));
hold on;                                                                        		%Warten bis zur Plotausgabe
plot(X,Y,'color','blue');
hold on;                                                                        		%Warten bis zur Plotausgabe
plot(X,xACHSE(X),'color','black');
grid on;                                                                        		%Warten bis zur Plotausgabe
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE aDIVDIFF aINTERPOLATIONSFORMEL aAX_WERTE aAX_WERTE_TEXT	%Workspace aufräumen
